<?php

namespace App\Observers;

use App\PpvPurchase;
use Illuminate\Support\Facades\Log;

class PpvPurchaseObserver
{
    public function saving(PpvPurchase $ppvPurchase)
    {
        // Check if the PPV purchase is expired and update the status
        if ($ppvPurchase->status == 1 && $ppvPurchase->expires_at < now()) {
            $ppvPurchase->status = 0;
            Log::info("PPV purchase expired and status updated.");
        }
    }
}
